/******************************************************************************
Ootake

 [RecentRom.cpp]
	ŋߋNQ[̈ꗗ\邽߂̃tH[

Copyright(C)2006-2018 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

******************************************************************************/

#define DIRECTINPUT_VERSION	0x0500	//KitaoǉBɂ邩ȂADirectInput5yB7ƂxBXy[XnA[킩₷B

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "RecentRom.h"
#include "resource.h"
#include "WinMain.h"
#include "App.h"
#include "Input.h"

#define LINE_LEN	48
#define N_LINES 	22

enum RecentComponent
{
	LISTBOX_SELECTEDROM = 1
};
static HWND			_hWndC[1+1]; //eR|[lg̃nh

static WNDPROC		_WPListBox; //L[tbN̂
static BOOL			_bKeyRepeatDown;
static BOOL			_bKeyRepeatUp;
static BOOL			_bKeyRepeatSel;
static BOOL			_bKeyRepeatRun;

static HBRUSH		_hMyb; //uVF
static HFONT		_hFontB; //XgptHg

static Uint32		_FontWidth;
static Uint32		_FontHeight;
static const char*	_pCaption = "\"Ootake\" Game Select";
static HINSTANCE	_hInstance = NULL;
static HWND 		_hWnd;
static BOOL 		_bToggle;

static Sint32		_SelectedRom = -1; //߂l(肵ꍇ1`9999Ԃ)BLZȂ-1Bݒ蒆0B
static Sint32*		_pSelectedRom;


/* tHg̍擾 */
static Uint32
get_font_height(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)(tm.tmHeight);
}

/* tHg̉擾 */
static Uint32
get_font_width(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)tm.tmAveCharWidth;
}


static void
set_window_size(
	HWND			hWnd)
{
	RECT	rc;
	Uint32	wndW = _FontWidth  * LINE_LEN - 3;
	Uint32	wndH = _FontHeight * N_LINES - 5;
	int		y;

	SetRect(&rc, 0, 0, wndW, wndH);
	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));
	wndW = rc.right - rc.left;
	wndH = rc.bottom - rc.top;
	GetWindowRect(WINMAIN_GetHwnd(), &rc);
	y = rc.top;
	if (y + (int)wndH > GetSystemMetrics(SM_CYSCREEN))
	{
		y = GetSystemMetrics(SM_CYSCREEN) - wndH ;
		if (y<0) y=0;
	}
	MoveWindow(hWnd, rc.left, y, wndW, wndH, TRUE);
}


//CloseBwnd_proc̒WM_CLOSE𑗂ƃnhsɂȂČ듮([O][P]L[ă_COJƃCEBhEeɂȂȂBv2.69ȑO)̂ŁAꂪKvBv2.70XV
static LRESULT CALLBACK
recent_close()
{
	RECENT_Deinit();
	if (_bToggle) //DirectDrawŃtXN[ꍇ
	{
		APP_RunEmulator(FALSE); //EBhEANeBuɂ邽߂Ƀj[\Ẵ|[YB
		APP_ToggleFullscreen(); //tXN[ɖ߂B
		APP_RunEmulator(TRUE); //Ń|[YĂȂƁAȂł̓|[Y܂ȂBDirectDrawׂ͍ȓ삪sœBDirect3DOKB
	}
	if (_SelectedRom == 0)
		_SelectedRom = -1; //LZ
	return 0;
}

//LISTBOXR|[lgł̃L[͂m邽߂̃tbN
static LRESULT CALLBACK
ListBoxProc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	if (uMsg == WM_CHAR) //L[͂ςɂ邽WM_KEYDOWNłȂWM_CHARgp
	{
		if (wParam == VK_ESCAPE) //EscL[Ă
			return recent_close(); //0ԂƂWM_CHARςɁBr[v炳ɍςށB
	}
	return CallWindowProc(_WPListBox, hWnd, uMsg, wParam, lParam);
} 

static LRESULT CALLBACK
recent_wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	switch(uMsg)
	{
	case WM_CREATE:
		EnableWindow(WINMAIN_GetHwnd(), FALSE);//KitaoǉBCEChE𖳌ă[_ɁB
		_bToggle = FALSE;
		if (APP_GetFullScreen())
		{
			if (APP_GetDrawMethod() == 2)
			{
				APP_ToggleFullscreen(); //DirectDraw̏ꍇAʂƃtH[JX̂ŁAEBhE[hɋB
				_bToggle = TRUE;
			}
			else
				ShowWindow(WINMAIN_GetHwnd(), SW_HIDE); //tXN[̏ꍇACEBhEBB
		}
		_hFontB = (HFONT)GetStockObject(SYSTEM_FONT);
		_FontWidth	= get_font_width(hWnd);
		_FontHeight = get_font_height(hWnd);
		set_window_size(hWnd);
		break;

	case WM_SIZE:
		if (_bToggle) //DirectDrawŃtXN[ꍇAؑ֌ɃEBhẼANeBuKv
		{
			SetForegroundWindow(WINMAIN_GetHwnd());
			SetForegroundWindow(hWnd);
		}
		break;

	case WM_PAINT:
		SetFocus(_hWnd);//Xg{bNXtH[JXO
		break;

	case WM_KEYDOWN:
		if (wParam == VK_ESCAPE)
		{
			_SelectedRom = -1; //LZ
			return recent_close();
		}
		if (wParam == 'O')
		{
			_SelectedRom = -2; //Open Rom
			return recent_close();
		}
		if (wParam == 'P')
		{
			_SelectedRom = -3; //Open Cue
			return recent_close();
		}
		break;

	case WM_COMMAND:
		switch(HIWORD(wParam))
		{
			case LBN_DBLCLK:
				//߂lݒ
				_SelectedRom = SendMessage(GetDlgItem(hWnd, LISTBOX_SELECTEDROM), LB_GETCURSEL, 0, 0) + 1;
				return recent_close();
		}
		break;

	case WM_CLOSE:
		return recent_close();
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static BOOL
recent_main()
{
	WNDCLASS	wc;
	HWND		hWnd;
	RECT		rc;
	Uint32		x;
	Uint32		y;
	Sint32		i;
	MSG			msg;
	Sint32		a;
	BOOL		ok;

	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = recent_wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = _hInstance;
	wc.hIcon		 = LoadIcon(_hInstance, MAKEINTRESOURCE(OOTAKEICON)); //ACRǂݍ
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	_hMyb = CreateSolidBrush(RGB(64,128,64)); //uV
	wc.hbrBackground = _hMyb;
	wc.lpszMenuName  = "";
	wc.lpszClassName = _pCaption;

	if (RegisterClass(&wc) == 0)
		return FALSE;

	hWnd = CreateWindow(
		_pCaption,
		_pCaption,
		WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		NULL, //eEBhEȂ̂قEBhE鏈
		NULL,
		_hInstance,
		NULL
	);

	if (hWnd == NULL)
		return FALSE;

	_hWnd = hWnd;

	//ROMZNgpXg{bNX쐬
	x = _FontWidth*2 - 2;
	y = _FontHeight - 5;
	_hWndC[1] = CreateWindow(
		"LISTBOX", "",
		WS_CHILD | WS_VISIBLE | LBS_NOTIFY,
		x, y, _FontWidth*44, _FontHeight*20,
		_hWnd, (HMENU)LISTBOX_SELECTEDROM, _hInstance, NULL
	);
	_WPListBox = (WNDPROC)GetWindowLong(_hWndC[1], GWL_WNDPROC); //L[tbN邽߂Ɍ̃vV[WAhXޔ
	SetWindowLong(_hWndC[1], GWL_WNDPROC, (LONG)ListBoxProc); //ÕtbNɏ
	SendMessage(_hWndC[1], WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ
	for (i=1; i<=20; i++)
		SendMessage(_hWndC[1], LB_ADDSTRING, 0, (LPARAM)APP_GetRecentRom(i));
	SendMessage(_hWndC[1], LB_SETCURSEL, 0, 0);

	ShowWindow(_hWnd, SW_SHOWNORMAL);
	UpdateWindow(_hWnd);
	GetWindowRect(_hWnd, &rc);
	SetWindowPos(_hWnd, HWND_TOP, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED);
	ImmAssociateContext(_hWnd, 0); //IME𖳌ɂ

	//[v
	while (_SelectedRom == 0)
	{
		Sleep(1);

		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

		if (APP_CheckButtonState(11)) //I{^ꍇ
		{
			//߂lݒ
			_SelectedRom = SendMessage(GetDlgItem(hWnd, LISTBOX_SELECTEDROM), LB_GETCURSEL, 0, 0) + 1;
			PostMessage(hWnd, WM_CLOSE, 0, 0);
		}
		if (APP_CheckButtonState(18)) //RUN{^ꍇ
		{
			if (_bKeyRepeatRun)
			{	//O񉟂āA܂ςȂ̏ꍇ
				if (!APP_CheckButtonState(18))
					_bKeyRepeatRun = FALSE;
			}
			else
			{
				//߂lݒ
				_SelectedRom = SendMessage(GetDlgItem(hWnd, LISTBOX_SELECTEDROM), LB_GETCURSEL, 0, 0) + 1;
				PostMessage(hWnd, WM_CLOSE, 0, 0);
			}
		}
		else
			_bKeyRepeatRun = FALSE;

		if (APP_CheckButtonState(12)) //II{^ꍇ
		{
			_SelectedRom = -1; //LZ
			PostMessage(hWnd, WM_CLOSE, 0, 0);
		}

		if (APP_CheckButtonState(2)) //{^ꍇ
		{
			if (_bKeyRepeatDown)
			{	//O񉟂āA܂ςȂ̏ꍇ
				if (!APP_CheckButtonState(2))
					_bKeyRepeatDown = FALSE;
			}
			else
			{
				a = SendMessage(GetDlgItem(hWnd, LISTBOX_SELECTEDROM), LB_GETCURSEL, 0, 0) + 1;
				if (a == 20)
					a = 0;
				SendMessage(GetDlgItem(hWnd, LISTBOX_SELECTEDROM), LB_SETCURSEL, (WPARAM)a, 0);
				_bKeyRepeatDown = TRUE;
			}
		}
		else
			_bKeyRepeatDown = FALSE;
		if ((APP_CheckButtonState(17))&&(APP_CheckFuncAndSelConflict())) //SELECT{^ꍇ
		{
			if (_bKeyRepeatSel)
			{	//O񉟂āA܂ςȂ̏ꍇ
				if (!APP_CheckButtonState(17))
					_bKeyRepeatSel = FALSE;
			}
			else
			{
				a = SendMessage(GetDlgItem(hWnd, LISTBOX_SELECTEDROM), LB_GETCURSEL, 0, 0) + 1;
				if (a == 20)
					a = 0;
				SendMessage(GetDlgItem(hWnd, LISTBOX_SELECTEDROM), LB_SETCURSEL, (WPARAM)a, 0);
				_bKeyRepeatSel = TRUE;
			}
		}
		else
			_bKeyRepeatSel = FALSE;

		if (APP_CheckButtonState(8)) //{^ꍇ
		{
			if (_bKeyRepeatUp)
			{	//O񉟂āA܂ςȂ̏ꍇ
				if (!APP_CheckButtonState(8))
					_bKeyRepeatUp = FALSE;
			}
			else
			{
				a = SendMessage(GetDlgItem(hWnd, LISTBOX_SELECTEDROM), LB_GETCURSEL, 0, 0) - 1;
				if (a == -1)
					a = 19;
				SendMessage(GetDlgItem(hWnd, LISTBOX_SELECTEDROM), LB_SETCURSEL, (WPARAM)a, 0);
				_bKeyRepeatUp = TRUE;
			}
		}
		else
			_bKeyRepeatUp = FALSE;

		ok = (GetForegroundWindow() == _hWnd); //EBhEANeBuȂTRUE

		if ((ok)||(APP_GetOpenRomButton() >= 300)) //ROMt@CJBv2.86
			if (APP_CheckShortcutKey(APP_GetOpenRomButton()))
				if (INPUT_CheckButtonState(APP_GetOpenRomButton()))
		{
			_SelectedRom = -2; //Open Rom
		}

		if ((ok)||(APP_GetOpenCueButton() >= 300)) //CDCXg[ꂽQ[iCUEjJBv2.86
			if (APP_CheckShortcutKey(APP_GetOpenCueButton()))
				if (INPUT_CheckButtonState(APP_GetOpenCueButton()))
		{
			_SelectedRom = -3; //Open Cue
		}
	}

	//L[𗣂܂ő҂BꂪȂƃQ[AɌ둀̉\B
	while ((APP_CheckButtonState(11))||(APP_CheckButtonState(12))||(APP_CheckButtonState(18))) //I,II,RUNL[Sė܂ő҂B
		Sleep(1);
	
	//߂lݒ
	*_pSelectedRom = _SelectedRom; //̏uԂApp.c ɐ䂪߂B

	return TRUE;
}


BOOL
RECENT_Init(
	HINSTANCE	hInstance,
	Sint32*		selectedRom)
{
	if (_hInstance != NULL)
		RECENT_Deinit();

	_hInstance = hInstance;

	_bKeyRepeatDown	= FALSE;
	_bKeyRepeatUp	= FALSE;
	_bKeyRepeatSel	= FALSE;
	_bKeyRepeatRun	= TRUE; //Run{^͉ꂽԂłĂ΂

	_pSelectedRom = selectedRom;
	_SelectedRom = 0;

	return recent_main();
}


void
RECENT_Deinit()
{
	if (_hInstance != NULL)
	{
		DestroyWindow(_hWnd);
		_hWnd = NULL;
		UnregisterClass(_pCaption, _hInstance);
		_hInstance = NULL;
		
		DeleteObject(_hFontB); //{^ptHgJ
		DeleteObject(_hMyb); //uVJ
		
		//CEBhEEnableɖ߂AOʂɁB
		if (APP_GetFullScreen())
			ShowWindow(WINMAIN_GetHwnd(), SW_SHOWNORMAL);
		EnableWindow(WINMAIN_GetHwnd(), TRUE);
		SetForegroundWindow(WINMAIN_GetHwnd());
	}
}

